#!/usr/bin/env python3

import numpy as np
import matplotlib.pyplot as plt
from scipy.optimize import root

def f(x, Bi):
  return x * np.tan(x) - Bi

Bi = 0.313
x_guess = 1.0
x_solver = root(f, x_guess, args=(Bi,))
x_root = x_solver.x[0]

print(Bi, x_root)

x_plt = np.linspace(0, 5, 101)

plt.figure()
plt.plot(x_plt, f(x_plt, Bi), 'b-')
plt.plot([0, 5], [0, 0], 'k--')
plt.plot(x_root, f(x_root, Bi), 'bo')
plt.ylim([-2, 2])
plt.show()
plt.close('all')
