#!/usr/bin/env python3

import numpy as np

# %%
# -------------
# Problem 11
# -------------
rho = 1e3 # density (kg/m^3)
mu = 1e-3 # viscosity (kg/m/s)
D = 1./12/3.2808 # pipe diameter (m)

def reynolds_number(Q_Lmin):
    """
    Compute the Reynolds number for pipe flow given a flow rate in (L/min)
    Q : Volumetric flow rate in liters per minute (L/min)
    Re : Reynolds number (dimensionless)
    """
    # Convert input units
    Q = Q_Lmin / 1e3 / 60 # L/min -> m^3/s

    # Velocity from Q = U A
    A = np.pi * (D**2) / 4.0  # cross-sectional area (m^2)
    U = Q / A

    # Reynolds number
    Re = rho * U * D / mu

    return Re

print('11')
print('Re(1 L/min) = ', reynolds_number(1.)) # 835
print()

# %%
# -------------
# Problem 12
# -------------

def g(x,y):
    if (x**2 + y**2 <= 4):
        val = np.sqrt(x)
    else:
        val = y**3
    return val

print('(12)')
print(g(1.4, 1.5)) #3.375
print()
