#-------------------------------------
# Lecture 09 -- Debugging
#-------------------------------------
#
# In HW 8, we made a plot of an equation A(t)
# where A and t came from
#
#   t_n+1 = t_n + dt
#   A_n+1 = A_n + dt*( (Ain - A_n)/tau - k A_n**2 )
#
# from t = 0 to t = 10 where Ain = 1, tau = 2, 
# k=0.1, dt = 0.1 and A(t=0) = A_0 = 0.
#
# Debug the python script below that makes a plot of this function

import numpy as np
import matplotlib.pyplot as plt

Ain = 1
tau = 2
k = 0.1
dt = 0.1
t_final = 10

Nsteps = int(t_final/dt)+1
A = np.zeros(Nsteps)
t = np.zeros(Nsteps)

for n in range(Nsteps-1):
    A[n+1] = A[n] + dt * ( (Ain-A[n])/tau - k*A[n]**2)
    t[n+1] = t[n] + dt

plt.rc('font', size=16)
plt.plot(t, A, 'k-')
plt.xlabel('t')
plt.ylabel('A')
plt.show()

# Bugs in this code:
# * Range is Nsteps --> should be Nsteps-1
# * Trying to access array's with parenthesis, e.g. A(n) --> Should be square brackets A[n]
# * Need to import the matplotlib.pylot module
# * The formula is not correct --> Parenthesis around (Ain-A[n]), 
#                              --> Should have k*A[n]**2, not A[n]**(1/2)


