#-------------------------------------
# Lecture 09 -- Debugging
#-------------------------------------
#
# In HW 8, we made a plot of an equation A(t)
# where A and t came from
#
#   t_n+1 = t_n + dt
#   A_n+1 = A_n + dt*( (Ain - A_n)/tau - k A_n**2 )
#
# from t = 0 to t = 10 where Ain = 1, tau = 2, 
# k=0.1, dt = 0.1 and A(t=0) = A_0 = 0.
#
# Debug the python script below that makes a plot of this function.
# While doing this, **write down** each step of the debugging process:
# * Observation
# * Hypothesis
# * Experiment


import numpy as np

Ain = 1
tau = 2
k = 0.1
dt = 0.1
t_final = 10

Nsteps = int(t_final/dt)+1
A = np.zeros(Nsteps)
t = np.zeros(Nsteps)

for n in range(Nsteps):
    A(n+1) = A(n) + dt * ( Ain-A(n)/tau  - A(n)**(1/2) )
    t(n+1) = t(n) + dt

plt.rc('font', size=16)
plt.plot(t, A, 'k-')
plt.xlabel('t')
plt.ylabel('A')
plt.show()


