#-------------------------------------
# Lecture 09 -- Debugging
#-------------------------------------

import numpy as np

# Debug the following code which is supposed to find 
# the transpose of the matrix

A = np.array([[ 5,  8,  4,  2],\
              [ 1, -6,  5, -7],\
              [-2,  2, -9,  1],\
              [-3,  5, -8,  7]])

A_transpose = np.zeros((4,4))

for i in range(np.shape(A)[0]):
    for j in range(np.shape(A)[1]):
        A_transpose[i,j] = A[j,i]

print(A_transpose-A.T)

# list of bugs:
# * (syntax error) Line 19 (A_transpose[i,j] = ...) needs to be indented
# * (execution error) argument to np.zeros needs to be a tuple (4,4)
# * (execution error) range needs to go from 0 to 4 (either hard coded or with np.shape function)
# * (logical error) A_transpose[i,j] = A[j,i]
