#!/usr/bin/env python3
#
# Lecture 23
# Example -- XLWings
#
import numpy as np
import xlwings as xw
from scipy.integrate import trapz
from scipy.interpolate import interp1d
import matplotlib.pyplot as plt

wb = xw.Book("Lec23-Ex-Toluene_Heat_Capacity.xlsm")
sheet = wb.sheets("Sheet1")

x = np.array(sheet.range("A2:A34").value)
y = np.array(sheet.range("B2:B34").value)

#(d)
# check the quadrature that we did
quad = trapz(y, x)
sheet.range("J14").value = quad

#(e)
# make a cubic spline
fspline = interp1d(x, y)

xplt = np.linspace(x[0], x[-1], 101)
yplt = fspline(xplt)

fig = plt.figure()
plt.rc("font", size=14)
plt.plot(x, y, 'ro')
plt.plot(xplt, yplt, 'k--')
plt.xlabel("Temperature (K)")
plt.ylabel("Heat Capacity (J/mol K)")

# add figure to Excel Sheet
sheet.pictures.add(fig, left=215, top=450)
#sheet.pictures.add(fig, name="Cp_v_T", update=True)
plt.close()

#(f)
# put part (f) here

wb.save()
#wb.close()
