#-----------------------------------------------------------
# Lecture 17 -- Fitting Practice 
#-----------------------------------------------------------

import numpy as np
import matplotlib.pyplot as plt

# Load the given x and y data from the file "Lec_13-Prac_2-data.dat" 
# and fit it to a fourth order polynomial. Make a plot of the data and the fit.
# Does a fourth order polynomial do a good job of fitting the data?

def rsq(y_data, y_pred):
    SSE = np.sum( (y_data - y_pred)**2 )
    SST = np.sum( (y_data - np.average(y_data))**2 )
    return 1 - SSE/SST

x_data, y_data = np.loadtxt('Lec17-data.dat', unpack=True)

p = np.polyfit(x_data, y_data, 4)
y_pred = np.polyval(p, x_data)
R2 = rsq(y_data, y_pred)

xx = np.linspace(0, 10, 101)
yy = np.polyval(p, xx)

plt.figure()
plt.plot(x_data, y_data, 'o')
plt.plot(xx, yy, 'r-')
plt.text(0, 0.95, 'R2 = %8.4f'%R2, fontsize=14)
plt.show()

# The curve does an okay job fitting the data.
